#ifndef __SWindowHandle__
#define __SWindowHandle__

#include <Basics/CCountedObject.hpp>

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Windowing
		{
			/**
			 * @struct SWindowHandle SWindowHandle.hpp
			 * @brief Cross Platform representation of a window handle
			 *
			 * @date 18/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: SWindowHandle.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			struct SWindowHandle
			{
				/** @cond */
				#ifdef WIN32
				/** @endcond */
					HWND m_windowHandle;				/**< Windows window handle */
				/** @cond */
				#else
				/** @endcond */
					WindowRef m_windowHandle;			/**< Mac window handle */
				/** @cond */
				#endif
				/** @endcond */

//	===========================================================================

				/**
				 * Check if we have a valid (not null) windowHandle
				 * @retval bool True if habdle is non null, false otherwise
				 */
				bool handleIsValid()
				{
					return (m_windowHandle != NULL);
				}

//	===========================================================================

			};
		}
	}
}
#endif	// End of SWindowHandle.hpp